/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import slimeknights.mantle.loot.builder.GenericLootModifierBuilder;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierLootModifier
extends LootModifier {
    protected ModifierLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public static GenericLootModifierBuilder<ModifierLootModifier> builder() {
        return GenericLootModifierBuilder.builder((GlobalLootModifierSerializer)((GlobalLootModifierSerializer)TinkerModifiers.modifierLootModifier.get()), ModifierLootModifier::new);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ToolStack tool;
        Entity entity;
        ItemStack stack = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        if (stack == null && (entity = (Entity)context.m_78953_(LootContextParams.f_81458_)) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            stack = living.m_6844_(ModifierLootingHandler.getLootingSlot(living));
        }
        if (stack != null && !(tool = ToolStack.from(stack)).isBroken()) {
            for (ModifierEntry entry : tool.getModifierList()) {
                generatedLoot = entry.getModifier().processLoot(tool, entry.getLevel(), generatedLoot, context);
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<ModifierLootModifier> {
        public ModifierLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            return new ModifierLootModifier(conditions);
        }

        public JsonObject write(ModifierLootModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

